/*
 * OMApplet.java
 *
 * Created on 9. M�rz 2004, 15:54
 */

package ch.hslu.cm.oo;

import ch.hslu.cm.oo.diagram.OMAssociationFigure;
import ch.hslu.cm.oo.diagram.OMClassFigure;
import ch.hslu.cm.oo.diagram.OMDependencyFigure;
import ch.hslu.cm.oo.diagram.OMGeneralizationFigure;
import ch.hslu.cm.oo.diagram.OMLinkFigure;
import ch.hslu.cm.oo.diagram.OMObjectFigure;
import ch.hslu.cm.oo.objectmodel.*;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import org.jhotdraw.app.action.edit.DeleteAction;
import org.jhotdraw.app.action.edit.DuplicateAction;
import org.jhotdraw.app.action.edit.SelectAllAction;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.event.ToolEvent;
import org.jhotdraw.draw.event.ToolListener;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.DelegationSelectionTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.*;
/**
 * Applet mit einem Editor für Klassen-Diagramme.
 *
 * @author  wrandels
 */
public class OMApplet extends JApplet implements ToolListener {
    private final static String VERSION = "0.44";
    private final static String NAME = "ConceptModeler[OO]";
    
    private LinkedList<Action> drawingActions;
    private LinkedList<Action> selectionActions;
    private UndoRedoManager undoManager;
    private ClassDiagram drawing;
    private ObjectModel simulation;
    private DefaultDrawingView drawingView;
    private DefaultDrawingEditor drawingEditor;

    @Override
    public void boundsInvalidated(ToolEvent e) {
    }
    
    private class ToolButtonListener implements ItemListener {
        private Tool tool;
        public ToolButtonListener(Tool t) {
            this.tool = t;
        }
        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == ItemEvent.SELECTED) {
                setTool(tool);
            }
        }
    }
    
    
    
    /**
     * Initializes the applet OMApplet
     */
    @Override
    public void init() {
        ResourceBundleUtil.setVerbose(true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Throwable e) {
            // Do nothing.
            // If we can't set the desired look and feel, UIManager does
            // automaticaly the right thing for us.
        }
        Container c = getContentPane();
        c.setLayout(new BoxLayout(c, BoxLayout.Y_AXIS));
        for (StringTokenizer tt = new StringTokenizer(getAppletInfo(), "\n"); tt.hasMoreTokens(); ) {
            c.add(new JLabel(tt.nextToken()));
        }
        
        new Worker() {
    @Override
            public Object construct() {
                Object result;
                try {
                    if (getParameter("data") != null) {
                        NanoXMLDOMInput domi = new NanoXMLDOMInput(new OMFactory(), new StringReader(getParameter("data")));
                        domi.openElement("ConceptModelerOO");
                        result = domi.readObject(0);
                    } else if (getParameter("datafile") != null) {
                        InputStream in = null;
                        try {
                            URL url = new URL(getDocumentBase(), getParameter("datafile"));
                            in = url.openConnection().getInputStream();
                            NanoXMLDOMInput domi = new NanoXMLDOMInput(new OMFactory(), in);
                            domi.openElement("ConceptModelerOO");
                            result = domi.readObject(0);
                        } finally {
                            if (in != null) in.close();
                        }
                    } else {
                        result = null;
                    }
                } catch (Throwable t) {
                    result = t;
                }
                return result;
            }
            @Override
            public void finished() {
                Container c = getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                
                Object result = getValue();
                initComponents();
                if (result != null && (result instanceof Drawing)) {
                    drawing = (ClassDiagram) result;
                } else {
                    drawing = new ClassDiagram();
                }
                drawingView.setDrawing(drawing);
                undoManager = new UndoRedoManager();
                drawing.addUndoableEditListener(undoManager);
                initTools();
                
                if (result != null && (result instanceof Throwable)) {
                    drawing.add(new TextFigure(result.toString()));
                }
                c.validate();
            }
        }.start();
    }

    @Override
    public String getAppletInfo() {
        return NAME+"\nVersion "+VERSION
        +"\n\nCopyright 2004 \u00a9 Lucerne University of Applied Sciences and Arts"
        +"\nAlle Rechte vorbehalten."
        +"\n\nDiese Software basiert auf"
        +"\nJHotDraw \u00a9 1996, 1997 IFA Informatik und Erich Gamma"
        +"\nNanoXML \u00a9 2000-2002 Marc De Scheemaecker";
    }
    
    private void initTools() {
        
        Tool selectionTool = new DelegationSelectionTool(getDrawingActions(), getSelectionActions());
        drawingEditor.setTool(selectionTool);
        selectionToolButton.addItemListener(
        new ToolButtonListener(selectionTool)
        );
        
        initCreationTools();
    }
    private void initCreationTools() {
        HashMap<AttributeKey,Object> attributes;
        OMAssociationFigure ac;
        
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(FILL_COLOR, ClassDiagram.CLASS_NAME_COMPARTMENT_COLOR);
        attributes.put(STROKE_COLOR, ClassDiagram.CLASS_STROKE_COLOR);
        attributes.put(TEXT_COLOR, ClassDiagram.CLASS_TEXT_COLOR);
        classToolButton.addItemListener(
        new ToolButtonListener(new CreationTool(new OMClassFigure(), attributes))
        );
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(FILL_COLOR, ClassDiagram.OBJECT_FILL_COLOR);
        attributes.put(STROKE_COLOR, ClassDiagram.OBJECT_STROKE_COLOR);
        attributes.put(TEXT_COLOR, ClassDiagram.OBJECT_TEXT_COLOR);
        objectToolButton.addItemListener(
        new ToolButtonListener(new CreationTool(new OMObjectFigure(), attributes))
        );
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(FILL_COLOR, ClassDiagram.GENERALIZATION_FILL_COLOR);
        attributes.put(STROKE_COLOR, ClassDiagram.GENERALIZATION_STROKE_COLOR);
        generalizationToolButton.addItemListener(
        new ToolButtonListener(new ConnectionTool(new OMGeneralizationFigure(), attributes))
        );
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(FILL_COLOR, ClassDiagram.ASSOCIATION_FILL_COLOR);
        attributes.put(STROKE_COLOR, ClassDiagram.ASSOCIATION_STROKE_COLOR);
        ac = new OMAssociationFigure();
        ac.getModel().setOwnerMultiplicity(1);
        ac.getModel().setMemberMultiplicity(1);
        association11ToolButton.addItemListener(
        new ToolButtonListener(new ConnectionTool(ac, attributes))
        );
        ac = new OMAssociationFigure();
        ac.getModel().setOwnerMultiplicity(1);
        ac.getModel().setMemberMultiplicity(-1);
        association1MToolButton.addItemListener(
        new ToolButtonListener(new ConnectionTool(ac, attributes))
        );
        ac = new OMAssociationFigure();
        ac.getModel().setOwnerMultiplicity(-1);
        ac.getModel().setMemberMultiplicity(-1);
        associationMMToolButton.addItemListener(
        new ToolButtonListener(new ConnectionTool(ac, attributes))
        );
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(FILL_COLOR, ClassDiagram.LINK_FILL_COLOR);
        attributes.put(STROKE_COLOR, ClassDiagram.LINK_STROKE_COLOR);
        linkToolButton.addItemListener(
        new ToolButtonListener(new ConnectionTool(new OMLinkFigure()))
        );
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(FILL_COLOR, ClassDiagram.DEPENDENCY_FILL_COLOR);
        attributes.put(STROKE_COLOR, ClassDiagram.DEPENDENCY_STROKE_COLOR);
        dependencyToolButton.addItemListener(
        new ToolButtonListener(new ConnectionTool(new OMDependencyFigure(), attributes))
        );
    }
    public void setData(String text) {
        drawing.removeAllChildren();
        if (text != null && text.length() > 0) {
            StringReader in = new StringReader(text);
            try {
                undoManager.discardAllEdits();
                NanoXMLDOMInput domi = new NanoXMLDOMInput(new OMFactory(), in);
                domi.openElement("ConceptModelerOO");
                
                final ObjectModel objectmodel;
                final ClassDiagram classdiagram;
                
                objectmodel = (ObjectModel) domi.readObject(0);
                classdiagram = (ClassDiagram) domi.readObject(1);
                
                classdiagram.putSimulation(objectmodel);
                drawing = classdiagram;
                simulation = objectmodel;
                drawingView.setDrawing(classdiagram);
                drawing.addUndoableEditListener(undoManager);
            } catch (Throwable e) {
                drawing.removeAllChildren();
                TextFigure tf = new TextFigure();
                tf.setText(e.getMessage());
                tf.setBounds(new Point2D.Double(10,10), new Point2D.Double(100,100));
                drawing.add(tf);
                e.printStackTrace();
            } finally {
                if (in != null) in.close();
            }
        }
    }
    public String getData() {
        CharArrayWriter out = new CharArrayWriter();
        try {
            NanoXMLDOMOutput domo = new NanoXMLDOMOutput(new OMFactory());
            domo.openElement("ConceptModelerOO");
            domo.writeObject(simulation);
            domo.writeObject(drawing);
            domo.closeElement();
            domo.save(out);
        } catch (IOException e) {
            TextFigure tf = new TextFigure();
            tf.setText(e.getMessage());
            tf.setBounds(new Point2D.Double(10,10), new Point2D.Double(100,100));
            drawing.add(tf);
            e.printStackTrace();
        } finally {
            if (out != null) out.close();
        }
        return out.toString();
    }
    private Collection<Action> getDrawingActions() {
        if (drawingActions == null) {
            drawingActions = new LinkedList<Action>();
            drawingActions.add(undoManager.getUndoAction());
            drawingActions.add(undoManager.getRedoAction());
            drawingActions.add(null); // separator
            drawingActions.add(new SelectAllAction());
        }
        return drawingActions;
    }
    private Collection<Action> getSelectionActions() {
        if (selectionActions == null) {
            selectionActions = new LinkedList<Action>();
            selectionActions.add(new DuplicateAction());
            selectionActions.add(new DeleteAction());
            selectionActions.add(null); // separator
            selectionActions.add(new GroupAction(drawingEditor));
            selectionActions.add(new UngroupAction(drawingEditor));
            selectionActions.add(null); // separator
            selectionActions.add(new BringToFrontAction(drawingEditor));
            selectionActions.add(new SendToBackAction(drawingEditor));
        }
        return selectionActions;
    }
    
    public void setTool(Tool newTool) {
        Tool oldTool = drawingEditor.getTool();
        if (oldTool != null && oldTool != newTool) {
            oldTool.removeToolListener(this);
        }
        drawingEditor.setTool(newTool);
        if (newTool != null) {
            newTool.addToolListener(this);
        }
    }
    
    @Override
    public void areaInvalidated(ToolEvent e) {
        // Empty
    }
    
    @Override
    public void toolDone(ToolEvent event) {
        selectionToolButton.setSelected(true);
    }
    
    @Override
    public String[][] getParameterInfo() {
        return new String[][] {
            { "data", "String", "the data to be displayed by this applet." },
            { "datafile", "URL", "an URL to the data to be displayed by this applet." }
        };
    }

    @Override
    public void toolStarted(ToolEvent event) {
    }
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        toolGroup = new javax.swing.ButtonGroup();
        jToolBar1 = new javax.swing.JToolBar();
        selectionToolButton = new javax.swing.JToggleButton();
        classToolButton = new javax.swing.JToggleButton();
        generalizationToolButton = new javax.swing.JToggleButton();
        association11ToolButton = new javax.swing.JToggleButton();
        association1MToolButton = new javax.swing.JToggleButton();
        associationMMToolButton = new javax.swing.JToggleButton();
        dependencyToolButton = new javax.swing.JToggleButton();
        objectToolButton = new javax.swing.JToggleButton();
        linkToolButton = new javax.swing.JToggleButton();
        jLabel1 = new javax.swing.JLabel();

        jToolBar1.setFloatable(false);
        toolGroup.add(selectionToolButton);
        selectionToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/draw/images/tool_select.png")));
        selectionToolButton.setSelected(true);
        jToolBar1.add(selectionToolButton);

        toolGroup.add(classToolButton);
        classToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/oo/images/tool_class.png")));
        classToolButton.setToolTipText("Klasse");
        jToolBar1.add(classToolButton);

        toolGroup.add(generalizationToolButton);
        generalizationToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/oo/images/tool_generalization.png")));
        generalizationToolButton.setToolTipText("Generalisierung");
        jToolBar1.add(generalizationToolButton);

        toolGroup.add(association11ToolButton);
        association11ToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/oo/images/tool_association11.png")));
        association11ToolButton.setToolTipText("1:1 Assoziation");
        jToolBar1.add(association11ToolButton);

        toolGroup.add(association1MToolButton);
        association1MToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/oo/images/tool_association1M.png")));
        association1MToolButton.setToolTipText("1:* Assoziation");
        jToolBar1.add(association1MToolButton);

        toolGroup.add(associationMMToolButton);
        associationMMToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/oo/images/tool_associationMM.png")));
        associationMMToolButton.setToolTipText("*:* Assoziation");
        jToolBar1.add(associationMMToolButton);

        toolGroup.add(dependencyToolButton);
        dependencyToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/oo/images/tool_dependency.png")));
        dependencyToolButton.setToolTipText("Abh\u00e4ngigkeit");
        jToolBar1.add(dependencyToolButton);

        toolGroup.add(objectToolButton);
        objectToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/cm/oo/images/tool_object.png")));
        objectToolButton.setToolTipText("Objekt");
        jToolBar1.add(objectToolButton);

        toolGroup.add(linkToolButton);
        linkToolButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/hslu/draw/images/tool_elbowlink.png")));
        linkToolButton.setToolTipText("Verbindung");
        jToolBar1.add(linkToolButton);

        getContentPane().add(jToolBar1, java.awt.BorderLayout.SOUTH);

        jLabel1.setText("jLabel1");
        getContentPane().add(jLabel1, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToggleButton association11ToolButton;
    private javax.swing.JToggleButton association1MToolButton;
    private javax.swing.JToggleButton associationMMToolButton;
    private javax.swing.JToggleButton classToolButton;
    private javax.swing.JToggleButton dependencyToolButton;
    private javax.swing.JToggleButton generalizationToolButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JToggleButton linkToolButton;
    private javax.swing.JToggleButton objectToolButton;
    private javax.swing.JToggleButton selectionToolButton;
    private javax.swing.ButtonGroup toolGroup;
    // End of variables declaration//GEN-END:variables
    
}
